<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/googleads/v12/errors/ad_error.proto

namespace Google\Ads\GoogleAds\V12\Errors\AdErrorEnum;

use UnexpectedValueException;

/**
 * Enum describing possible ad errors.
 *
 * Protobuf type <code>google.ads.googleads.v12.errors.AdErrorEnum.AdError</code>
 */
class AdError
{
    /**
     * Enum unspecified.
     *
     * Generated from protobuf enum <code>UNSPECIFIED = 0;</code>
     */
    const UNSPECIFIED = 0;
    /**
     * The received error code is not known in this version.
     *
     * Generated from protobuf enum <code>UNKNOWN = 1;</code>
     */
    const UNKNOWN = 1;
    /**
     * Ad customizers are not supported for ad type.
     *
     * Generated from protobuf enum <code>AD_CUSTOMIZERS_NOT_SUPPORTED_FOR_AD_TYPE = 2;</code>
     */
    const AD_CUSTOMIZERS_NOT_SUPPORTED_FOR_AD_TYPE = 2;
    /**
     * Estimating character sizes the string is too long.
     *
     * Generated from protobuf enum <code>APPROXIMATELY_TOO_LONG = 3;</code>
     */
    const APPROXIMATELY_TOO_LONG = 3;
    /**
     * Estimating character sizes the string is too short.
     *
     * Generated from protobuf enum <code>APPROXIMATELY_TOO_SHORT = 4;</code>
     */
    const APPROXIMATELY_TOO_SHORT = 4;
    /**
     * There is a problem with the snippet.
     *
     * Generated from protobuf enum <code>BAD_SNIPPET = 5;</code>
     */
    const BAD_SNIPPET = 5;
    /**
     * Cannot modify an ad.
     *
     * Generated from protobuf enum <code>CANNOT_MODIFY_AD = 6;</code>
     */
    const CANNOT_MODIFY_AD = 6;
    /**
     * business name and url cannot be set at the same time
     *
     * Generated from protobuf enum <code>CANNOT_SET_BUSINESS_NAME_IF_URL_SET = 7;</code>
     */
    const CANNOT_SET_BUSINESS_NAME_IF_URL_SET = 7;
    /**
     * The specified field is incompatible with this ad's type or settings.
     *
     * Generated from protobuf enum <code>CANNOT_SET_FIELD = 8;</code>
     */
    const CANNOT_SET_FIELD = 8;
    /**
     * Cannot set field when originAdId is set.
     *
     * Generated from protobuf enum <code>CANNOT_SET_FIELD_WITH_ORIGIN_AD_ID_SET = 9;</code>
     */
    const CANNOT_SET_FIELD_WITH_ORIGIN_AD_ID_SET = 9;
    /**
     * Cannot set field when an existing ad id is set for sharing.
     *
     * Generated from protobuf enum <code>CANNOT_SET_FIELD_WITH_AD_ID_SET_FOR_SHARING = 10;</code>
     */
    const CANNOT_SET_FIELD_WITH_AD_ID_SET_FOR_SHARING = 10;
    /**
     * Cannot set allowFlexibleColor false if no color is provided by user.
     *
     * Generated from protobuf enum <code>CANNOT_SET_ALLOW_FLEXIBLE_COLOR_FALSE = 11;</code>
     */
    const CANNOT_SET_ALLOW_FLEXIBLE_COLOR_FALSE = 11;
    /**
     * When user select native, no color control is allowed because we will
     * always respect publisher color for native format serving.
     *
     * Generated from protobuf enum <code>CANNOT_SET_COLOR_CONTROL_WHEN_NATIVE_FORMAT_SETTING = 12;</code>
     */
    const CANNOT_SET_COLOR_CONTROL_WHEN_NATIVE_FORMAT_SETTING = 12;
    /**
     * Cannot specify a url for the ad type
     *
     * Generated from protobuf enum <code>CANNOT_SET_URL = 13;</code>
     */
    const CANNOT_SET_URL = 13;
    /**
     * Cannot specify a tracking or mobile url without also setting final urls
     *
     * Generated from protobuf enum <code>CANNOT_SET_WITHOUT_FINAL_URLS = 14;</code>
     */
    const CANNOT_SET_WITHOUT_FINAL_URLS = 14;
    /**
     * Cannot specify a legacy url and a final url simultaneously
     *
     * Generated from protobuf enum <code>CANNOT_SET_WITH_FINAL_URLS = 15;</code>
     */
    const CANNOT_SET_WITH_FINAL_URLS = 15;
    /**
     * Cannot specify a urls in UrlData and in template fields simultaneously.
     *
     * Generated from protobuf enum <code>CANNOT_SET_WITH_URL_DATA = 17;</code>
     */
    const CANNOT_SET_WITH_URL_DATA = 17;
    /**
     * This operator cannot be used with a subclass of Ad.
     *
     * Generated from protobuf enum <code>CANNOT_USE_AD_SUBCLASS_FOR_OPERATOR = 18;</code>
     */
    const CANNOT_USE_AD_SUBCLASS_FOR_OPERATOR = 18;
    /**
     * Customer is not approved for mobile ads.
     *
     * Generated from protobuf enum <code>CUSTOMER_NOT_APPROVED_MOBILEADS = 19;</code>
     */
    const CUSTOMER_NOT_APPROVED_MOBILEADS = 19;
    /**
     * Customer is not approved for 3PAS richmedia ads.
     *
     * Generated from protobuf enum <code>CUSTOMER_NOT_APPROVED_THIRDPARTY_ADS = 20;</code>
     */
    const CUSTOMER_NOT_APPROVED_THIRDPARTY_ADS = 20;
    /**
     * Customer is not approved for 3PAS redirect richmedia (Ad Exchange) ads.
     *
     * Generated from protobuf enum <code>CUSTOMER_NOT_APPROVED_THIRDPARTY_REDIRECT_ADS = 21;</code>
     */
    const CUSTOMER_NOT_APPROVED_THIRDPARTY_REDIRECT_ADS = 21;
    /**
     * Not an eligible customer
     *
     * Generated from protobuf enum <code>CUSTOMER_NOT_ELIGIBLE = 22;</code>
     */
    const CUSTOMER_NOT_ELIGIBLE = 22;
    /**
     * Customer is not eligible for updating beacon url
     *
     * Generated from protobuf enum <code>CUSTOMER_NOT_ELIGIBLE_FOR_UPDATING_BEACON_URL = 23;</code>
     */
    const CUSTOMER_NOT_ELIGIBLE_FOR_UPDATING_BEACON_URL = 23;
    /**
     * There already exists an ad with the same dimensions in the union.
     *
     * Generated from protobuf enum <code>DIMENSION_ALREADY_IN_UNION = 24;</code>
     */
    const DIMENSION_ALREADY_IN_UNION = 24;
    /**
     * Ad's dimension must be set before setting union dimension.
     *
     * Generated from protobuf enum <code>DIMENSION_MUST_BE_SET = 25;</code>
     */
    const DIMENSION_MUST_BE_SET = 25;
    /**
     * Ad's dimension must be included in the union dimensions.
     *
     * Generated from protobuf enum <code>DIMENSION_NOT_IN_UNION = 26;</code>
     */
    const DIMENSION_NOT_IN_UNION = 26;
    /**
     * Display Url cannot be specified (applies to Ad Exchange Ads)
     *
     * Generated from protobuf enum <code>DISPLAY_URL_CANNOT_BE_SPECIFIED = 27;</code>
     */
    const DISPLAY_URL_CANNOT_BE_SPECIFIED = 27;
    /**
     * Telephone number contains invalid characters or invalid format.
     * Re-enter your number using digits (0-9), dashes (-), and parentheses
     * only.
     *
     * Generated from protobuf enum <code>DOMESTIC_PHONE_NUMBER_FORMAT = 28;</code>
     */
    const DOMESTIC_PHONE_NUMBER_FORMAT = 28;
    /**
     * Emergency telephone numbers are not allowed. Enter a valid
     * domestic phone number to connect customers to your business.
     *
     * Generated from protobuf enum <code>EMERGENCY_PHONE_NUMBER = 29;</code>
     */
    const EMERGENCY_PHONE_NUMBER = 29;
    /**
     * A required field was not specified or is an empty string.
     *
     * Generated from protobuf enum <code>EMPTY_FIELD = 30;</code>
     */
    const EMPTY_FIELD = 30;
    /**
     * A feed attribute referenced in an ad customizer tag is not in the ad
     * customizer mapping for the feed.
     *
     * Generated from protobuf enum <code>FEED_ATTRIBUTE_MUST_HAVE_MAPPING_FOR_TYPE_ID = 31;</code>
     */
    const FEED_ATTRIBUTE_MUST_HAVE_MAPPING_FOR_TYPE_ID = 31;
    /**
     * The ad customizer field mapping for the feed attribute does not match the
     * expected field type.
     *
     * Generated from protobuf enum <code>FEED_ATTRIBUTE_MAPPING_TYPE_MISMATCH = 32;</code>
     */
    const FEED_ATTRIBUTE_MAPPING_TYPE_MISMATCH = 32;
    /**
     * The use of ad customizer tags in the ad text is disallowed. Details in
     * trigger.
     *
     * Generated from protobuf enum <code>ILLEGAL_AD_CUSTOMIZER_TAG_USE = 33;</code>
     */
    const ILLEGAL_AD_CUSTOMIZER_TAG_USE = 33;
    /**
     * Tags of the form {PH_x}, where x is a number, are disallowed in ad text.
     *
     * Generated from protobuf enum <code>ILLEGAL_TAG_USE = 34;</code>
     */
    const ILLEGAL_TAG_USE = 34;
    /**
     * The dimensions of the ad are specified or derived in multiple ways and
     * are not consistent.
     *
     * Generated from protobuf enum <code>INCONSISTENT_DIMENSIONS = 35;</code>
     */
    const INCONSISTENT_DIMENSIONS = 35;
    /**
     * The status cannot differ among template ads of the same union.
     *
     * Generated from protobuf enum <code>INCONSISTENT_STATUS_IN_TEMPLATE_UNION = 36;</code>
     */
    const INCONSISTENT_STATUS_IN_TEMPLATE_UNION = 36;
    /**
     * The length of the string is not valid.
     *
     * Generated from protobuf enum <code>INCORRECT_LENGTH = 37;</code>
     */
    const INCORRECT_LENGTH = 37;
    /**
     * The ad is ineligible for upgrade.
     *
     * Generated from protobuf enum <code>INELIGIBLE_FOR_UPGRADE = 38;</code>
     */
    const INELIGIBLE_FOR_UPGRADE = 38;
    /**
     * User cannot create mobile ad for countries targeted in specified
     * campaign.
     *
     * Generated from protobuf enum <code>INVALID_AD_ADDRESS_CAMPAIGN_TARGET = 39;</code>
     */
    const INVALID_AD_ADDRESS_CAMPAIGN_TARGET = 39;
    /**
     * Invalid Ad type. A specific type of Ad is required.
     *
     * Generated from protobuf enum <code>INVALID_AD_TYPE = 40;</code>
     */
    const INVALID_AD_TYPE = 40;
    /**
     * Headline, description or phone cannot be present when creating mobile
     * image ad.
     *
     * Generated from protobuf enum <code>INVALID_ATTRIBUTES_FOR_MOBILE_IMAGE = 41;</code>
     */
    const INVALID_ATTRIBUTES_FOR_MOBILE_IMAGE = 41;
    /**
     * Image cannot be present when creating mobile text ad.
     *
     * Generated from protobuf enum <code>INVALID_ATTRIBUTES_FOR_MOBILE_TEXT = 42;</code>
     */
    const INVALID_ATTRIBUTES_FOR_MOBILE_TEXT = 42;
    /**
     * Invalid call to action text.
     *
     * Generated from protobuf enum <code>INVALID_CALL_TO_ACTION_TEXT = 43;</code>
     */
    const INVALID_CALL_TO_ACTION_TEXT = 43;
    /**
     * Invalid character in URL.
     *
     * Generated from protobuf enum <code>INVALID_CHARACTER_FOR_URL = 44;</code>
     */
    const INVALID_CHARACTER_FOR_URL = 44;
    /**
     * Creative's country code is not valid.
     *
     * Generated from protobuf enum <code>INVALID_COUNTRY_CODE = 45;</code>
     */
    const INVALID_COUNTRY_CODE = 45;
    /**
     * Invalid use of Expanded Dynamic Search Ads tags ({lpurl} etc.)
     *
     * Generated from protobuf enum <code>INVALID_EXPANDED_DYNAMIC_SEARCH_AD_TAG = 47;</code>
     */
    const INVALID_EXPANDED_DYNAMIC_SEARCH_AD_TAG = 47;
    /**
     * An input error whose real reason was not properly mapped (should not
     * happen).
     *
     * Generated from protobuf enum <code>INVALID_INPUT = 48;</code>
     */
    const INVALID_INPUT = 48;
    /**
     * An invalid markup language was entered.
     *
     * Generated from protobuf enum <code>INVALID_MARKUP_LANGUAGE = 49;</code>
     */
    const INVALID_MARKUP_LANGUAGE = 49;
    /**
     * An invalid mobile carrier was entered.
     *
     * Generated from protobuf enum <code>INVALID_MOBILE_CARRIER = 50;</code>
     */
    const INVALID_MOBILE_CARRIER = 50;
    /**
     * Specified mobile carriers target a country not targeted by the campaign.
     *
     * Generated from protobuf enum <code>INVALID_MOBILE_CARRIER_TARGET = 51;</code>
     */
    const INVALID_MOBILE_CARRIER_TARGET = 51;
    /**
     * Wrong number of elements for given element type
     *
     * Generated from protobuf enum <code>INVALID_NUMBER_OF_ELEMENTS = 52;</code>
     */
    const INVALID_NUMBER_OF_ELEMENTS = 52;
    /**
     * The format of the telephone number is incorrect. Re-enter the
     * number using the correct format.
     *
     * Generated from protobuf enum <code>INVALID_PHONE_NUMBER_FORMAT = 53;</code>
     */
    const INVALID_PHONE_NUMBER_FORMAT = 53;
    /**
     * The certified vendor format id is incorrect.
     *
     * Generated from protobuf enum <code>INVALID_RICH_MEDIA_CERTIFIED_VENDOR_FORMAT_ID = 54;</code>
     */
    const INVALID_RICH_MEDIA_CERTIFIED_VENDOR_FORMAT_ID = 54;
    /**
     * The template ad data contains validation errors.
     *
     * Generated from protobuf enum <code>INVALID_TEMPLATE_DATA = 55;</code>
     */
    const INVALID_TEMPLATE_DATA = 55;
    /**
     * The template field doesn't have have the correct type.
     *
     * Generated from protobuf enum <code>INVALID_TEMPLATE_ELEMENT_FIELD_TYPE = 56;</code>
     */
    const INVALID_TEMPLATE_ELEMENT_FIELD_TYPE = 56;
    /**
     * Invalid template id.
     *
     * Generated from protobuf enum <code>INVALID_TEMPLATE_ID = 57;</code>
     */
    const INVALID_TEMPLATE_ID = 57;
    /**
     * After substituting replacement strings, the line is too wide.
     *
     * Generated from protobuf enum <code>LINE_TOO_WIDE = 58;</code>
     */
    const LINE_TOO_WIDE = 58;
    /**
     * The feed referenced must have ad customizer mapping to be used in a
     * customizer tag.
     *
     * Generated from protobuf enum <code>MISSING_AD_CUSTOMIZER_MAPPING = 59;</code>
     */
    const MISSING_AD_CUSTOMIZER_MAPPING = 59;
    /**
     * Missing address component in template element address field.
     *
     * Generated from protobuf enum <code>MISSING_ADDRESS_COMPONENT = 60;</code>
     */
    const MISSING_ADDRESS_COMPONENT = 60;
    /**
     * An ad name must be entered.
     *
     * Generated from protobuf enum <code>MISSING_ADVERTISEMENT_NAME = 61;</code>
     */
    const MISSING_ADVERTISEMENT_NAME = 61;
    /**
     * Business name must be entered.
     *
     * Generated from protobuf enum <code>MISSING_BUSINESS_NAME = 62;</code>
     */
    const MISSING_BUSINESS_NAME = 62;
    /**
     * Description (line 2) must be entered.
     *
     * Generated from protobuf enum <code>MISSING_DESCRIPTION1 = 63;</code>
     */
    const MISSING_DESCRIPTION1 = 63;
    /**
     * Description (line 3) must be entered.
     *
     * Generated from protobuf enum <code>MISSING_DESCRIPTION2 = 64;</code>
     */
    const MISSING_DESCRIPTION2 = 64;
    /**
     * The destination url must contain at least one tag (for example, {lpurl})
     *
     * Generated from protobuf enum <code>MISSING_DESTINATION_URL_TAG = 65;</code>
     */
    const MISSING_DESTINATION_URL_TAG = 65;
    /**
     * The tracking url template of ExpandedDynamicSearchAd must contain at
     * least one tag. (for example, {lpurl})
     *
     * Generated from protobuf enum <code>MISSING_LANDING_PAGE_URL_TAG = 66;</code>
     */
    const MISSING_LANDING_PAGE_URL_TAG = 66;
    /**
     * A valid dimension must be specified for this ad.
     *
     * Generated from protobuf enum <code>MISSING_DIMENSION = 67;</code>
     */
    const MISSING_DIMENSION = 67;
    /**
     * A display URL must be entered.
     *
     * Generated from protobuf enum <code>MISSING_DISPLAY_URL = 68;</code>
     */
    const MISSING_DISPLAY_URL = 68;
    /**
     * Headline must be entered.
     *
     * Generated from protobuf enum <code>MISSING_HEADLINE = 69;</code>
     */
    const MISSING_HEADLINE = 69;
    /**
     * A height must be entered.
     *
     * Generated from protobuf enum <code>MISSING_HEIGHT = 70;</code>
     */
    const MISSING_HEIGHT = 70;
    /**
     * An image must be entered.
     *
     * Generated from protobuf enum <code>MISSING_IMAGE = 71;</code>
     */
    const MISSING_IMAGE = 71;
    /**
     * Marketing image or product videos are required.
     *
     * Generated from protobuf enum <code>MISSING_MARKETING_IMAGE_OR_PRODUCT_VIDEOS = 72;</code>
     */
    const MISSING_MARKETING_IMAGE_OR_PRODUCT_VIDEOS = 72;
    /**
     * The markup language in which your site is written must be entered.
     *
     * Generated from protobuf enum <code>MISSING_MARKUP_LANGUAGES = 73;</code>
     */
    const MISSING_MARKUP_LANGUAGES = 73;
    /**
     * A mobile carrier must be entered.
     *
     * Generated from protobuf enum <code>MISSING_MOBILE_CARRIER = 74;</code>
     */
    const MISSING_MOBILE_CARRIER = 74;
    /**
     * Phone number must be entered.
     *
     * Generated from protobuf enum <code>MISSING_PHONE = 75;</code>
     */
    const MISSING_PHONE = 75;
    /**
     * Missing required template fields
     *
     * Generated from protobuf enum <code>MISSING_REQUIRED_TEMPLATE_FIELDS = 76;</code>
     */
    const MISSING_REQUIRED_TEMPLATE_FIELDS = 76;
    /**
     * Missing a required field value
     *
     * Generated from protobuf enum <code>MISSING_TEMPLATE_FIELD_VALUE = 77;</code>
     */
    const MISSING_TEMPLATE_FIELD_VALUE = 77;
    /**
     * The ad must have text.
     *
     * Generated from protobuf enum <code>MISSING_TEXT = 78;</code>
     */
    const MISSING_TEXT = 78;
    /**
     * A visible URL must be entered.
     *
     * Generated from protobuf enum <code>MISSING_VISIBLE_URL = 79;</code>
     */
    const MISSING_VISIBLE_URL = 79;
    /**
     * A width must be entered.
     *
     * Generated from protobuf enum <code>MISSING_WIDTH = 80;</code>
     */
    const MISSING_WIDTH = 80;
    /**
     * Only 1 feed can be used as the source of ad customizer substitutions in a
     * single ad.
     *
     * Generated from protobuf enum <code>MULTIPLE_DISTINCT_FEEDS_UNSUPPORTED = 81;</code>
     */
    const MULTIPLE_DISTINCT_FEEDS_UNSUPPORTED = 81;
    /**
     * TempAdUnionId must be use when adding template ads.
     *
     * Generated from protobuf enum <code>MUST_USE_TEMP_AD_UNION_ID_ON_ADD = 82;</code>
     */
    const MUST_USE_TEMP_AD_UNION_ID_ON_ADD = 82;
    /**
     * The string has too many characters.
     *
     * Generated from protobuf enum <code>TOO_LONG = 83;</code>
     */
    const TOO_LONG = 83;
    /**
     * The string has too few characters.
     *
     * Generated from protobuf enum <code>TOO_SHORT = 84;</code>
     */
    const TOO_SHORT = 84;
    /**
     * Ad union dimensions cannot change for saved ads.
     *
     * Generated from protobuf enum <code>UNION_DIMENSIONS_CANNOT_CHANGE = 85;</code>
     */
    const UNION_DIMENSIONS_CANNOT_CHANGE = 85;
    /**
     * Address component is not {country, lat, lng}.
     *
     * Generated from protobuf enum <code>UNKNOWN_ADDRESS_COMPONENT = 86;</code>
     */
    const UNKNOWN_ADDRESS_COMPONENT = 86;
    /**
     * Unknown unique field name
     *
     * Generated from protobuf enum <code>UNKNOWN_FIELD_NAME = 87;</code>
     */
    const UNKNOWN_FIELD_NAME = 87;
    /**
     * Unknown unique name (template element type specifier)
     *
     * Generated from protobuf enum <code>UNKNOWN_UNIQUE_NAME = 88;</code>
     */
    const UNKNOWN_UNIQUE_NAME = 88;
    /**
     * Unsupported ad dimension
     *
     * Generated from protobuf enum <code>UNSUPPORTED_DIMENSIONS = 89;</code>
     */
    const UNSUPPORTED_DIMENSIONS = 89;
    /**
     * URL starts with an invalid scheme.
     *
     * Generated from protobuf enum <code>URL_INVALID_SCHEME = 90;</code>
     */
    const URL_INVALID_SCHEME = 90;
    /**
     * URL ends with an invalid top-level domain name.
     *
     * Generated from protobuf enum <code>URL_INVALID_TOP_LEVEL_DOMAIN = 91;</code>
     */
    const URL_INVALID_TOP_LEVEL_DOMAIN = 91;
    /**
     * URL contains illegal characters.
     *
     * Generated from protobuf enum <code>URL_MALFORMED = 92;</code>
     */
    const URL_MALFORMED = 92;
    /**
     * URL must contain a host name.
     *
     * Generated from protobuf enum <code>URL_NO_HOST = 93;</code>
     */
    const URL_NO_HOST = 93;
    /**
     * URL not equivalent during upgrade.
     *
     * Generated from protobuf enum <code>URL_NOT_EQUIVALENT = 94;</code>
     */
    const URL_NOT_EQUIVALENT = 94;
    /**
     * URL host name too long to be stored as visible URL (applies to Ad
     * Exchange ads)
     *
     * Generated from protobuf enum <code>URL_HOST_NAME_TOO_LONG = 95;</code>
     */
    const URL_HOST_NAME_TOO_LONG = 95;
    /**
     * URL must start with a scheme.
     *
     * Generated from protobuf enum <code>URL_NO_SCHEME = 96;</code>
     */
    const URL_NO_SCHEME = 96;
    /**
     * URL should end in a valid domain extension, such as .com or .net.
     *
     * Generated from protobuf enum <code>URL_NO_TOP_LEVEL_DOMAIN = 97;</code>
     */
    const URL_NO_TOP_LEVEL_DOMAIN = 97;
    /**
     * URL must not end with a path.
     *
     * Generated from protobuf enum <code>URL_PATH_NOT_ALLOWED = 98;</code>
     */
    const URL_PATH_NOT_ALLOWED = 98;
    /**
     * URL must not specify a port.
     *
     * Generated from protobuf enum <code>URL_PORT_NOT_ALLOWED = 99;</code>
     */
    const URL_PORT_NOT_ALLOWED = 99;
    /**
     * URL must not contain a query.
     *
     * Generated from protobuf enum <code>URL_QUERY_NOT_ALLOWED = 100;</code>
     */
    const URL_QUERY_NOT_ALLOWED = 100;
    /**
     * A url scheme is not allowed in front of tag in tracking url template
     * (for example, http://{lpurl})
     *
     * Generated from protobuf enum <code>URL_SCHEME_BEFORE_EXPANDED_DYNAMIC_SEARCH_AD_TAG = 102;</code>
     */
    const URL_SCHEME_BEFORE_EXPANDED_DYNAMIC_SEARCH_AD_TAG = 102;
    /**
     * The user does not have permissions to create a template ad for the given
     * template.
     *
     * Generated from protobuf enum <code>USER_DOES_NOT_HAVE_ACCESS_TO_TEMPLATE = 103;</code>
     */
    const USER_DOES_NOT_HAVE_ACCESS_TO_TEMPLATE = 103;
    /**
     * Expandable setting is inconsistent/wrong. For example, an AdX ad is
     * invalid if it has a expandable vendor format but no expanding directions
     * specified, or expanding directions is specified, but the vendor format is
     * not expandable.
     *
     * Generated from protobuf enum <code>INCONSISTENT_EXPANDABLE_SETTINGS = 104;</code>
     */
    const INCONSISTENT_EXPANDABLE_SETTINGS = 104;
    /**
     * Format is invalid
     *
     * Generated from protobuf enum <code>INVALID_FORMAT = 105;</code>
     */
    const INVALID_FORMAT = 105;
    /**
     * The text of this field did not match a pattern of allowed values.
     *
     * Generated from protobuf enum <code>INVALID_FIELD_TEXT = 106;</code>
     */
    const INVALID_FIELD_TEXT = 106;
    /**
     * Template element is mising
     *
     * Generated from protobuf enum <code>ELEMENT_NOT_PRESENT = 107;</code>
     */
    const ELEMENT_NOT_PRESENT = 107;
    /**
     * Error occurred during image processing
     *
     * Generated from protobuf enum <code>IMAGE_ERROR = 108;</code>
     */
    const IMAGE_ERROR = 108;
    /**
     * The value is not within the valid range
     *
     * Generated from protobuf enum <code>VALUE_NOT_IN_RANGE = 109;</code>
     */
    const VALUE_NOT_IN_RANGE = 109;
    /**
     * Template element field is not present
     *
     * Generated from protobuf enum <code>FIELD_NOT_PRESENT = 110;</code>
     */
    const FIELD_NOT_PRESENT = 110;
    /**
     * Address is incomplete
     *
     * Generated from protobuf enum <code>ADDRESS_NOT_COMPLETE = 111;</code>
     */
    const ADDRESS_NOT_COMPLETE = 111;
    /**
     * Invalid address
     *
     * Generated from protobuf enum <code>ADDRESS_INVALID = 112;</code>
     */
    const ADDRESS_INVALID = 112;
    /**
     * Error retrieving specified video
     *
     * Generated from protobuf enum <code>VIDEO_RETRIEVAL_ERROR = 113;</code>
     */
    const VIDEO_RETRIEVAL_ERROR = 113;
    /**
     * Error processing audio
     *
     * Generated from protobuf enum <code>AUDIO_ERROR = 114;</code>
     */
    const AUDIO_ERROR = 114;
    /**
     * Display URL is incorrect for YouTube PYV ads
     *
     * Generated from protobuf enum <code>INVALID_YOUTUBE_DISPLAY_URL = 115;</code>
     */
    const INVALID_YOUTUBE_DISPLAY_URL = 115;
    /**
     * Too many product Images in GmailAd
     *
     * Generated from protobuf enum <code>TOO_MANY_PRODUCT_IMAGES = 116;</code>
     */
    const TOO_MANY_PRODUCT_IMAGES = 116;
    /**
     * Too many product Videos in GmailAd
     *
     * Generated from protobuf enum <code>TOO_MANY_PRODUCT_VIDEOS = 117;</code>
     */
    const TOO_MANY_PRODUCT_VIDEOS = 117;
    /**
     * The device preference is not compatible with the ad type
     *
     * Generated from protobuf enum <code>INCOMPATIBLE_AD_TYPE_AND_DEVICE_PREFERENCE = 118;</code>
     */
    const INCOMPATIBLE_AD_TYPE_AND_DEVICE_PREFERENCE = 118;
    /**
     * Call tracking is not supported for specified country.
     *
     * Generated from protobuf enum <code>CALLTRACKING_NOT_SUPPORTED_FOR_COUNTRY = 119;</code>
     */
    const CALLTRACKING_NOT_SUPPORTED_FOR_COUNTRY = 119;
    /**
     * Carrier specific short number is not allowed.
     *
     * Generated from protobuf enum <code>CARRIER_SPECIFIC_SHORT_NUMBER_NOT_ALLOWED = 120;</code>
     */
    const CARRIER_SPECIFIC_SHORT_NUMBER_NOT_ALLOWED = 120;
    /**
     * Specified phone number type is disallowed.
     *
     * Generated from protobuf enum <code>DISALLOWED_NUMBER_TYPE = 121;</code>
     */
    const DISALLOWED_NUMBER_TYPE = 121;
    /**
     * Phone number not supported for country.
     *
     * Generated from protobuf enum <code>PHONE_NUMBER_NOT_SUPPORTED_FOR_COUNTRY = 122;</code>
     */
    const PHONE_NUMBER_NOT_SUPPORTED_FOR_COUNTRY = 122;
    /**
     * Phone number not supported with call tracking enabled for country.
     *
     * Generated from protobuf enum <code>PHONE_NUMBER_NOT_SUPPORTED_WITH_CALLTRACKING_FOR_COUNTRY = 123;</code>
     */
    const PHONE_NUMBER_NOT_SUPPORTED_WITH_CALLTRACKING_FOR_COUNTRY = 123;
    /**
     * Premium rate phone number is not allowed.
     *
     * Generated from protobuf enum <code>PREMIUM_RATE_NUMBER_NOT_ALLOWED = 124;</code>
     */
    const PREMIUM_RATE_NUMBER_NOT_ALLOWED = 124;
    /**
     * Vanity phone number is not allowed.
     *
     * Generated from protobuf enum <code>VANITY_PHONE_NUMBER_NOT_ALLOWED = 125;</code>
     */
    const VANITY_PHONE_NUMBER_NOT_ALLOWED = 125;
    /**
     * Invalid call conversion type id.
     *
     * Generated from protobuf enum <code>INVALID_CALL_CONVERSION_TYPE_ID = 126;</code>
     */
    const INVALID_CALL_CONVERSION_TYPE_ID = 126;
    /**
     * Cannot disable call conversion and set conversion type id.
     *
     * Generated from protobuf enum <code>CANNOT_DISABLE_CALL_CONVERSION_AND_SET_CONVERSION_TYPE_ID = 127;</code>
     */
    const CANNOT_DISABLE_CALL_CONVERSION_AND_SET_CONVERSION_TYPE_ID = 127;
    /**
     * Cannot set path2 without path1.
     *
     * Generated from protobuf enum <code>CANNOT_SET_PATH2_WITHOUT_PATH1 = 128;</code>
     */
    const CANNOT_SET_PATH2_WITHOUT_PATH1 = 128;
    /**
     * Missing domain name in campaign setting when adding expanded dynamic
     * search ad.
     *
     * Generated from protobuf enum <code>MISSING_DYNAMIC_SEARCH_ADS_SETTING_DOMAIN_NAME = 129;</code>
     */
    const MISSING_DYNAMIC_SEARCH_ADS_SETTING_DOMAIN_NAME = 129;
    /**
     * The associated ad is not compatible with restriction type.
     *
     * Generated from protobuf enum <code>INCOMPATIBLE_WITH_RESTRICTION_TYPE = 130;</code>
     */
    const INCOMPATIBLE_WITH_RESTRICTION_TYPE = 130;
    /**
     * Consent for call recording is required for creating/updating call only
     * ads. See https://support.google.com/google-ads/answer/7412639.
     *
     * Generated from protobuf enum <code>CUSTOMER_CONSENT_FOR_CALL_RECORDING_REQUIRED = 131;</code>
     */
    const CUSTOMER_CONSENT_FOR_CALL_RECORDING_REQUIRED = 131;
    /**
     * Either an image or a media bundle is required in a display upload ad.
     *
     * Generated from protobuf enum <code>MISSING_IMAGE_OR_MEDIA_BUNDLE = 132;</code>
     */
    const MISSING_IMAGE_OR_MEDIA_BUNDLE = 132;
    /**
     * The display upload product type is not supported in this campaign.
     *
     * Generated from protobuf enum <code>PRODUCT_TYPE_NOT_SUPPORTED_IN_THIS_CAMPAIGN = 133;</code>
     */
    const PRODUCT_TYPE_NOT_SUPPORTED_IN_THIS_CAMPAIGN = 133;
    /**
     * The default value of an ad placeholder can not be the empty string.
     *
     * Generated from protobuf enum <code>PLACEHOLDER_CANNOT_HAVE_EMPTY_DEFAULT_VALUE = 134;</code>
     */
    const PLACEHOLDER_CANNOT_HAVE_EMPTY_DEFAULT_VALUE = 134;
    /**
     * Ad placeholders with countdown functions must not have a default value.
     *
     * Generated from protobuf enum <code>PLACEHOLDER_COUNTDOWN_FUNCTION_CANNOT_HAVE_DEFAULT_VALUE = 135;</code>
     */
    const PLACEHOLDER_COUNTDOWN_FUNCTION_CANNOT_HAVE_DEFAULT_VALUE = 135;
    /**
     * A previous ad placeholder that had a default value was found which means
     * that all (non-countdown) placeholders must have a default value. This
     * ad placeholder does not have a default value.
     *
     * Generated from protobuf enum <code>PLACEHOLDER_DEFAULT_VALUE_MISSING = 136;</code>
     */
    const PLACEHOLDER_DEFAULT_VALUE_MISSING = 136;
    /**
     * A previous ad placeholder that did not have a default value was found
     * which means that no placeholders may have a default value. This
     * ad placeholder does have a default value.
     *
     * Generated from protobuf enum <code>UNEXPECTED_PLACEHOLDER_DEFAULT_VALUE = 137;</code>
     */
    const UNEXPECTED_PLACEHOLDER_DEFAULT_VALUE = 137;
    /**
     * Two ad customizers may not be directly adjacent in an ad text. They must
     * be separated by at least one character.
     *
     * Generated from protobuf enum <code>AD_CUSTOMIZERS_MAY_NOT_BE_ADJACENT = 138;</code>
     */
    const AD_CUSTOMIZERS_MAY_NOT_BE_ADJACENT = 138;
    /**
     * The ad is not associated with any enabled AdGroupAd, and cannot be
     * updated.
     *
     * Generated from protobuf enum <code>UPDATING_AD_WITH_NO_ENABLED_ASSOCIATION = 139;</code>
     */
    const UPDATING_AD_WITH_NO_ENABLED_ASSOCIATION = 139;
    /**
     * Call Ad verification url and final url don't have same domain.
     *
     * Generated from protobuf enum <code>CALL_AD_VERIFICATION_URL_FINAL_URL_DOES_NOT_HAVE_SAME_DOMAIN = 140;</code>
     */
    const CALL_AD_VERIFICATION_URL_FINAL_URL_DOES_NOT_HAVE_SAME_DOMAIN = 140;
    /**
     * Final url and verification url cannot both be empty for call ads.
     *
     * Generated from protobuf enum <code>CALL_AD_FINAL_URL_AND_VERIFICATION_URL_CANNOT_BOTH_BE_EMPTY = 154;</code>
     */
    const CALL_AD_FINAL_URL_AND_VERIFICATION_URL_CANNOT_BOTH_BE_EMPTY = 154;
    /**
     * Too many ad customizers in one asset.
     *
     * Generated from protobuf enum <code>TOO_MANY_AD_CUSTOMIZERS = 141;</code>
     */
    const TOO_MANY_AD_CUSTOMIZERS = 141;
    /**
     * The ad customizer tag is recognized, but the format is invalid.
     *
     * Generated from protobuf enum <code>INVALID_AD_CUSTOMIZER_FORMAT = 142;</code>
     */
    const INVALID_AD_CUSTOMIZER_FORMAT = 142;
    /**
     * Customizer tags cannot be nested.
     *
     * Generated from protobuf enum <code>NESTED_AD_CUSTOMIZER_SYNTAX = 143;</code>
     */
    const NESTED_AD_CUSTOMIZER_SYNTAX = 143;
    /**
     * The ad customizer syntax used in the ad is not supported.
     *
     * Generated from protobuf enum <code>UNSUPPORTED_AD_CUSTOMIZER_SYNTAX = 144;</code>
     */
    const UNSUPPORTED_AD_CUSTOMIZER_SYNTAX = 144;
    /**
     * There exists unpaired brace in the ad customizer tag.
     *
     * Generated from protobuf enum <code>UNPAIRED_BRACE_IN_AD_CUSTOMIZER_TAG = 145;</code>
     */
    const UNPAIRED_BRACE_IN_AD_CUSTOMIZER_TAG = 145;
    /**
     * More than one type of countdown tag exists among all text lines.
     *
     * Generated from protobuf enum <code>MORE_THAN_ONE_COUNTDOWN_TAG_TYPE_EXISTS = 146;</code>
     */
    const MORE_THAN_ONE_COUNTDOWN_TAG_TYPE_EXISTS = 146;
    /**
     * Date time in the countdown tag is invalid.
     *
     * Generated from protobuf enum <code>DATE_TIME_IN_COUNTDOWN_TAG_IS_INVALID = 147;</code>
     */
    const DATE_TIME_IN_COUNTDOWN_TAG_IS_INVALID = 147;
    /**
     * Date time in the countdown tag is in the past.
     *
     * Generated from protobuf enum <code>DATE_TIME_IN_COUNTDOWN_TAG_IS_PAST = 148;</code>
     */
    const DATE_TIME_IN_COUNTDOWN_TAG_IS_PAST = 148;
    /**
     * Cannot recognize the ad customizer tag.
     *
     * Generated from protobuf enum <code>UNRECOGNIZED_AD_CUSTOMIZER_TAG_FOUND = 149;</code>
     */
    const UNRECOGNIZED_AD_CUSTOMIZER_TAG_FOUND = 149;
    /**
     * Customizer type forbidden for this field.
     *
     * Generated from protobuf enum <code>CUSTOMIZER_TYPE_FORBIDDEN_FOR_FIELD = 150;</code>
     */
    const CUSTOMIZER_TYPE_FORBIDDEN_FOR_FIELD = 150;
    /**
     * Customizer attribute name is invalid.
     *
     * Generated from protobuf enum <code>INVALID_CUSTOMIZER_ATTRIBUTE_NAME = 151;</code>
     */
    const INVALID_CUSTOMIZER_ATTRIBUTE_NAME = 151;
    /**
     * App store value does not match the value of the app store in the app
     * specified in the campaign.
     *
     * Generated from protobuf enum <code>STORE_MISMATCH = 152;</code>
     */
    const STORE_MISMATCH = 152;
    /**
     * Missing required image aspect ratio.
     *
     * Generated from protobuf enum <code>MISSING_REQUIRED_IMAGE_ASPECT_RATIO = 153;</code>
     */
    const MISSING_REQUIRED_IMAGE_ASPECT_RATIO = 153;
    /**
     * Aspect ratios mismatch between different assets.
     *
     * Generated from protobuf enum <code>MISMATCHED_ASPECT_RATIOS = 155;</code>
     */
    const MISMATCHED_ASPECT_RATIOS = 155;
    /**
     * Images must be unique between different carousel card assets.
     *
     * Generated from protobuf enum <code>DUPLICATE_IMAGE_ACROSS_CAROUSEL_CARDS = 156;</code>
     */
    const DUPLICATE_IMAGE_ACROSS_CAROUSEL_CARDS = 156;

    private static $valueToName = [
        self::UNSPECIFIED => 'UNSPECIFIED',
        self::UNKNOWN => 'UNKNOWN',
        self::AD_CUSTOMIZERS_NOT_SUPPORTED_FOR_AD_TYPE => 'AD_CUSTOMIZERS_NOT_SUPPORTED_FOR_AD_TYPE',
        self::APPROXIMATELY_TOO_LONG => 'APPROXIMATELY_TOO_LONG',
        self::APPROXIMATELY_TOO_SHORT => 'APPROXIMATELY_TOO_SHORT',
        self::BAD_SNIPPET => 'BAD_SNIPPET',
        self::CANNOT_MODIFY_AD => 'CANNOT_MODIFY_AD',
        self::CANNOT_SET_BUSINESS_NAME_IF_URL_SET => 'CANNOT_SET_BUSINESS_NAME_IF_URL_SET',
        self::CANNOT_SET_FIELD => 'CANNOT_SET_FIELD',
        self::CANNOT_SET_FIELD_WITH_ORIGIN_AD_ID_SET => 'CANNOT_SET_FIELD_WITH_ORIGIN_AD_ID_SET',
        self::CANNOT_SET_FIELD_WITH_AD_ID_SET_FOR_SHARING => 'CANNOT_SET_FIELD_WITH_AD_ID_SET_FOR_SHARING',
        self::CANNOT_SET_ALLOW_FLEXIBLE_COLOR_FALSE => 'CANNOT_SET_ALLOW_FLEXIBLE_COLOR_FALSE',
        self::CANNOT_SET_COLOR_CONTROL_WHEN_NATIVE_FORMAT_SETTING => 'CANNOT_SET_COLOR_CONTROL_WHEN_NATIVE_FORMAT_SETTING',
        self::CANNOT_SET_URL => 'CANNOT_SET_URL',
        self::CANNOT_SET_WITHOUT_FINAL_URLS => 'CANNOT_SET_WITHOUT_FINAL_URLS',
        self::CANNOT_SET_WITH_FINAL_URLS => 'CANNOT_SET_WITH_FINAL_URLS',
        self::CANNOT_SET_WITH_URL_DATA => 'CANNOT_SET_WITH_URL_DATA',
        self::CANNOT_USE_AD_SUBCLASS_FOR_OPERATOR => 'CANNOT_USE_AD_SUBCLASS_FOR_OPERATOR',
        self::CUSTOMER_NOT_APPROVED_MOBILEADS => 'CUSTOMER_NOT_APPROVED_MOBILEADS',
        self::CUSTOMER_NOT_APPROVED_THIRDPARTY_ADS => 'CUSTOMER_NOT_APPROVED_THIRDPARTY_ADS',
        self::CUSTOMER_NOT_APPROVED_THIRDPARTY_REDIRECT_ADS => 'CUSTOMER_NOT_APPROVED_THIRDPARTY_REDIRECT_ADS',
        self::CUSTOMER_NOT_ELIGIBLE => 'CUSTOMER_NOT_ELIGIBLE',
        self::CUSTOMER_NOT_ELIGIBLE_FOR_UPDATING_BEACON_URL => 'CUSTOMER_NOT_ELIGIBLE_FOR_UPDATING_BEACON_URL',
        self::DIMENSION_ALREADY_IN_UNION => 'DIMENSION_ALREADY_IN_UNION',
        self::DIMENSION_MUST_BE_SET => 'DIMENSION_MUST_BE_SET',
        self::DIMENSION_NOT_IN_UNION => 'DIMENSION_NOT_IN_UNION',
        self::DISPLAY_URL_CANNOT_BE_SPECIFIED => 'DISPLAY_URL_CANNOT_BE_SPECIFIED',
        self::DOMESTIC_PHONE_NUMBER_FORMAT => 'DOMESTIC_PHONE_NUMBER_FORMAT',
        self::EMERGENCY_PHONE_NUMBER => 'EMERGENCY_PHONE_NUMBER',
        self::EMPTY_FIELD => 'EMPTY_FIELD',
        self::FEED_ATTRIBUTE_MUST_HAVE_MAPPING_FOR_TYPE_ID => 'FEED_ATTRIBUTE_MUST_HAVE_MAPPING_FOR_TYPE_ID',
        self::FEED_ATTRIBUTE_MAPPING_TYPE_MISMATCH => 'FEED_ATTRIBUTE_MAPPING_TYPE_MISMATCH',
        self::ILLEGAL_AD_CUSTOMIZER_TAG_USE => 'ILLEGAL_AD_CUSTOMIZER_TAG_USE',
        self::ILLEGAL_TAG_USE => 'ILLEGAL_TAG_USE',
        self::INCONSISTENT_DIMENSIONS => 'INCONSISTENT_DIMENSIONS',
        self::INCONSISTENT_STATUS_IN_TEMPLATE_UNION => 'INCONSISTENT_STATUS_IN_TEMPLATE_UNION',
        self::INCORRECT_LENGTH => 'INCORRECT_LENGTH',
        self::INELIGIBLE_FOR_UPGRADE => 'INELIGIBLE_FOR_UPGRADE',
        self::INVALID_AD_ADDRESS_CAMPAIGN_TARGET => 'INVALID_AD_ADDRESS_CAMPAIGN_TARGET',
        self::INVALID_AD_TYPE => 'INVALID_AD_TYPE',
        self::INVALID_ATTRIBUTES_FOR_MOBILE_IMAGE => 'INVALID_ATTRIBUTES_FOR_MOBILE_IMAGE',
        self::INVALID_ATTRIBUTES_FOR_MOBILE_TEXT => 'INVALID_ATTRIBUTES_FOR_MOBILE_TEXT',
        self::INVALID_CALL_TO_ACTION_TEXT => 'INVALID_CALL_TO_ACTION_TEXT',
        self::INVALID_CHARACTER_FOR_URL => 'INVALID_CHARACTER_FOR_URL',
        self::INVALID_COUNTRY_CODE => 'INVALID_COUNTRY_CODE',
        self::INVALID_EXPANDED_DYNAMIC_SEARCH_AD_TAG => 'INVALID_EXPANDED_DYNAMIC_SEARCH_AD_TAG',
        self::INVALID_INPUT => 'INVALID_INPUT',
        self::INVALID_MARKUP_LANGUAGE => 'INVALID_MARKUP_LANGUAGE',
        self::INVALID_MOBILE_CARRIER => 'INVALID_MOBILE_CARRIER',
        self::INVALID_MOBILE_CARRIER_TARGET => 'INVALID_MOBILE_CARRIER_TARGET',
        self::INVALID_NUMBER_OF_ELEMENTS => 'INVALID_NUMBER_OF_ELEMENTS',
        self::INVALID_PHONE_NUMBER_FORMAT => 'INVALID_PHONE_NUMBER_FORMAT',
        self::INVALID_RICH_MEDIA_CERTIFIED_VENDOR_FORMAT_ID => 'INVALID_RICH_MEDIA_CERTIFIED_VENDOR_FORMAT_ID',
        self::INVALID_TEMPLATE_DATA => 'INVALID_TEMPLATE_DATA',
        self::INVALID_TEMPLATE_ELEMENT_FIELD_TYPE => 'INVALID_TEMPLATE_ELEMENT_FIELD_TYPE',
        self::INVALID_TEMPLATE_ID => 'INVALID_TEMPLATE_ID',
        self::LINE_TOO_WIDE => 'LINE_TOO_WIDE',
        self::MISSING_AD_CUSTOMIZER_MAPPING => 'MISSING_AD_CUSTOMIZER_MAPPING',
        self::MISSING_ADDRESS_COMPONENT => 'MISSING_ADDRESS_COMPONENT',
        self::MISSING_ADVERTISEMENT_NAME => 'MISSING_ADVERTISEMENT_NAME',
        self::MISSING_BUSINESS_NAME => 'MISSING_BUSINESS_NAME',
        self::MISSING_DESCRIPTION1 => 'MISSING_DESCRIPTION1',
        self::MISSING_DESCRIPTION2 => 'MISSING_DESCRIPTION2',
        self::MISSING_DESTINATION_URL_TAG => 'MISSING_DESTINATION_URL_TAG',
        self::MISSING_LANDING_PAGE_URL_TAG => 'MISSING_LANDING_PAGE_URL_TAG',
        self::MISSING_DIMENSION => 'MISSING_DIMENSION',
        self::MISSING_DISPLAY_URL => 'MISSING_DISPLAY_URL',
        self::MISSING_HEADLINE => 'MISSING_HEADLINE',
        self::MISSING_HEIGHT => 'MISSING_HEIGHT',
        self::MISSING_IMAGE => 'MISSING_IMAGE',
        self::MISSING_MARKETING_IMAGE_OR_PRODUCT_VIDEOS => 'MISSING_MARKETING_IMAGE_OR_PRODUCT_VIDEOS',
        self::MISSING_MARKUP_LANGUAGES => 'MISSING_MARKUP_LANGUAGES',
        self::MISSING_MOBILE_CARRIER => 'MISSING_MOBILE_CARRIER',
        self::MISSING_PHONE => 'MISSING_PHONE',
        self::MISSING_REQUIRED_TEMPLATE_FIELDS => 'MISSING_REQUIRED_TEMPLATE_FIELDS',
        self::MISSING_TEMPLATE_FIELD_VALUE => 'MISSING_TEMPLATE_FIELD_VALUE',
        self::MISSING_TEXT => 'MISSING_TEXT',
        self::MISSING_VISIBLE_URL => 'MISSING_VISIBLE_URL',
        self::MISSING_WIDTH => 'MISSING_WIDTH',
        self::MULTIPLE_DISTINCT_FEEDS_UNSUPPORTED => 'MULTIPLE_DISTINCT_FEEDS_UNSUPPORTED',
        self::MUST_USE_TEMP_AD_UNION_ID_ON_ADD => 'MUST_USE_TEMP_AD_UNION_ID_ON_ADD',
        self::TOO_LONG => 'TOO_LONG',
        self::TOO_SHORT => 'TOO_SHORT',
        self::UNION_DIMENSIONS_CANNOT_CHANGE => 'UNION_DIMENSIONS_CANNOT_CHANGE',
        self::UNKNOWN_ADDRESS_COMPONENT => 'UNKNOWN_ADDRESS_COMPONENT',
        self::UNKNOWN_FIELD_NAME => 'UNKNOWN_FIELD_NAME',
        self::UNKNOWN_UNIQUE_NAME => 'UNKNOWN_UNIQUE_NAME',
        self::UNSUPPORTED_DIMENSIONS => 'UNSUPPORTED_DIMENSIONS',
        self::URL_INVALID_SCHEME => 'URL_INVALID_SCHEME',
        self::URL_INVALID_TOP_LEVEL_DOMAIN => 'URL_INVALID_TOP_LEVEL_DOMAIN',
        self::URL_MALFORMED => 'URL_MALFORMED',
        self::URL_NO_HOST => 'URL_NO_HOST',
        self::URL_NOT_EQUIVALENT => 'URL_NOT_EQUIVALENT',
        self::URL_HOST_NAME_TOO_LONG => 'URL_HOST_NAME_TOO_LONG',
        self::URL_NO_SCHEME => 'URL_NO_SCHEME',
        self::URL_NO_TOP_LEVEL_DOMAIN => 'URL_NO_TOP_LEVEL_DOMAIN',
        self::URL_PATH_NOT_ALLOWED => 'URL_PATH_NOT_ALLOWED',
        self::URL_PORT_NOT_ALLOWED => 'URL_PORT_NOT_ALLOWED',
        self::URL_QUERY_NOT_ALLOWED => 'URL_QUERY_NOT_ALLOWED',
        self::URL_SCHEME_BEFORE_EXPANDED_DYNAMIC_SEARCH_AD_TAG => 'URL_SCHEME_BEFORE_EXPANDED_DYNAMIC_SEARCH_AD_TAG',
        self::USER_DOES_NOT_HAVE_ACCESS_TO_TEMPLATE => 'USER_DOES_NOT_HAVE_ACCESS_TO_TEMPLATE',
        self::INCONSISTENT_EXPANDABLE_SETTINGS => 'INCONSISTENT_EXPANDABLE_SETTINGS',
        self::INVALID_FORMAT => 'INVALID_FORMAT',
        self::INVALID_FIELD_TEXT => 'INVALID_FIELD_TEXT',
        self::ELEMENT_NOT_PRESENT => 'ELEMENT_NOT_PRESENT',
        self::IMAGE_ERROR => 'IMAGE_ERROR',
        self::VALUE_NOT_IN_RANGE => 'VALUE_NOT_IN_RANGE',
        self::FIELD_NOT_PRESENT => 'FIELD_NOT_PRESENT',
        self::ADDRESS_NOT_COMPLETE => 'ADDRESS_NOT_COMPLETE',
        self::ADDRESS_INVALID => 'ADDRESS_INVALID',
        self::VIDEO_RETRIEVAL_ERROR => 'VIDEO_RETRIEVAL_ERROR',
        self::AUDIO_ERROR => 'AUDIO_ERROR',
        self::INVALID_YOUTUBE_DISPLAY_URL => 'INVALID_YOUTUBE_DISPLAY_URL',
        self::TOO_MANY_PRODUCT_IMAGES => 'TOO_MANY_PRODUCT_IMAGES',
        self::TOO_MANY_PRODUCT_VIDEOS => 'TOO_MANY_PRODUCT_VIDEOS',
        self::INCOMPATIBLE_AD_TYPE_AND_DEVICE_PREFERENCE => 'INCOMPATIBLE_AD_TYPE_AND_DEVICE_PREFERENCE',
        self::CALLTRACKING_NOT_SUPPORTED_FOR_COUNTRY => 'CALLTRACKING_NOT_SUPPORTED_FOR_COUNTRY',
        self::CARRIER_SPECIFIC_SHORT_NUMBER_NOT_ALLOWED => 'CARRIER_SPECIFIC_SHORT_NUMBER_NOT_ALLOWED',
        self::DISALLOWED_NUMBER_TYPE => 'DISALLOWED_NUMBER_TYPE',
        self::PHONE_NUMBER_NOT_SUPPORTED_FOR_COUNTRY => 'PHONE_NUMBER_NOT_SUPPORTED_FOR_COUNTRY',
        self::PHONE_NUMBER_NOT_SUPPORTED_WITH_CALLTRACKING_FOR_COUNTRY => 'PHONE_NUMBER_NOT_SUPPORTED_WITH_CALLTRACKING_FOR_COUNTRY',
        self::PREMIUM_RATE_NUMBER_NOT_ALLOWED => 'PREMIUM_RATE_NUMBER_NOT_ALLOWED',
        self::VANITY_PHONE_NUMBER_NOT_ALLOWED => 'VANITY_PHONE_NUMBER_NOT_ALLOWED',
        self::INVALID_CALL_CONVERSION_TYPE_ID => 'INVALID_CALL_CONVERSION_TYPE_ID',
        self::CANNOT_DISABLE_CALL_CONVERSION_AND_SET_CONVERSION_TYPE_ID => 'CANNOT_DISABLE_CALL_CONVERSION_AND_SET_CONVERSION_TYPE_ID',
        self::CANNOT_SET_PATH2_WITHOUT_PATH1 => 'CANNOT_SET_PATH2_WITHOUT_PATH1',
        self::MISSING_DYNAMIC_SEARCH_ADS_SETTING_DOMAIN_NAME => 'MISSING_DYNAMIC_SEARCH_ADS_SETTING_DOMAIN_NAME',
        self::INCOMPATIBLE_WITH_RESTRICTION_TYPE => 'INCOMPATIBLE_WITH_RESTRICTION_TYPE',
        self::CUSTOMER_CONSENT_FOR_CALL_RECORDING_REQUIRED => 'CUSTOMER_CONSENT_FOR_CALL_RECORDING_REQUIRED',
        self::MISSING_IMAGE_OR_MEDIA_BUNDLE => 'MISSING_IMAGE_OR_MEDIA_BUNDLE',
        self::PRODUCT_TYPE_NOT_SUPPORTED_IN_THIS_CAMPAIGN => 'PRODUCT_TYPE_NOT_SUPPORTED_IN_THIS_CAMPAIGN',
        self::PLACEHOLDER_CANNOT_HAVE_EMPTY_DEFAULT_VALUE => 'PLACEHOLDER_CANNOT_HAVE_EMPTY_DEFAULT_VALUE',
        self::PLACEHOLDER_COUNTDOWN_FUNCTION_CANNOT_HAVE_DEFAULT_VALUE => 'PLACEHOLDER_COUNTDOWN_FUNCTION_CANNOT_HAVE_DEFAULT_VALUE',
        self::PLACEHOLDER_DEFAULT_VALUE_MISSING => 'PLACEHOLDER_DEFAULT_VALUE_MISSING',
        self::UNEXPECTED_PLACEHOLDER_DEFAULT_VALUE => 'UNEXPECTED_PLACEHOLDER_DEFAULT_VALUE',
        self::AD_CUSTOMIZERS_MAY_NOT_BE_ADJACENT => 'AD_CUSTOMIZERS_MAY_NOT_BE_ADJACENT',
        self::UPDATING_AD_WITH_NO_ENABLED_ASSOCIATION => 'UPDATING_AD_WITH_NO_ENABLED_ASSOCIATION',
        self::CALL_AD_VERIFICATION_URL_FINAL_URL_DOES_NOT_HAVE_SAME_DOMAIN => 'CALL_AD_VERIFICATION_URL_FINAL_URL_DOES_NOT_HAVE_SAME_DOMAIN',
        self::CALL_AD_FINAL_URL_AND_VERIFICATION_URL_CANNOT_BOTH_BE_EMPTY => 'CALL_AD_FINAL_URL_AND_VERIFICATION_URL_CANNOT_BOTH_BE_EMPTY',
        self::TOO_MANY_AD_CUSTOMIZERS => 'TOO_MANY_AD_CUSTOMIZERS',
        self::INVALID_AD_CUSTOMIZER_FORMAT => 'INVALID_AD_CUSTOMIZER_FORMAT',
        self::NESTED_AD_CUSTOMIZER_SYNTAX => 'NESTED_AD_CUSTOMIZER_SYNTAX',
        self::UNSUPPORTED_AD_CUSTOMIZER_SYNTAX => 'UNSUPPORTED_AD_CUSTOMIZER_SYNTAX',
        self::UNPAIRED_BRACE_IN_AD_CUSTOMIZER_TAG => 'UNPAIRED_BRACE_IN_AD_CUSTOMIZER_TAG',
        self::MORE_THAN_ONE_COUNTDOWN_TAG_TYPE_EXISTS => 'MORE_THAN_ONE_COUNTDOWN_TAG_TYPE_EXISTS',
        self::DATE_TIME_IN_COUNTDOWN_TAG_IS_INVALID => 'DATE_TIME_IN_COUNTDOWN_TAG_IS_INVALID',
        self::DATE_TIME_IN_COUNTDOWN_TAG_IS_PAST => 'DATE_TIME_IN_COUNTDOWN_TAG_IS_PAST',
        self::UNRECOGNIZED_AD_CUSTOMIZER_TAG_FOUND => 'UNRECOGNIZED_AD_CUSTOMIZER_TAG_FOUND',
        self::CUSTOMIZER_TYPE_FORBIDDEN_FOR_FIELD => 'CUSTOMIZER_TYPE_FORBIDDEN_FOR_FIELD',
        self::INVALID_CUSTOMIZER_ATTRIBUTE_NAME => 'INVALID_CUSTOMIZER_ATTRIBUTE_NAME',
        self::STORE_MISMATCH => 'STORE_MISMATCH',
        self::MISSING_REQUIRED_IMAGE_ASPECT_RATIO => 'MISSING_REQUIRED_IMAGE_ASPECT_RATIO',
        self::MISMATCHED_ASPECT_RATIOS => 'MISMATCHED_ASPECT_RATIOS',
        self::DUPLICATE_IMAGE_ACROSS_CAROUSEL_CARDS => 'DUPLICATE_IMAGE_ACROSS_CAROUSEL_CARDS',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AdError::class, \Google\Ads\GoogleAds\V12\Errors\AdErrorEnum_AdError::class);

